<!--
=========================================================
Painel P2P Plus - v1.0
=========================================================
Created by Albeci Nogueira (PLAYLIVE.TOP)
=========================================================
-->
<?php
if (debugEnabled()) {
    error_reporting(32767);
    ini_set("display_errors", 1);
} else {
    error_reporting(0);
    ini_set("display_errors", 0);
}
date_default_timezone_set('America/Sao_Paulo');
if (file_exists(__DIR__ . "/config.php")) {
    include_once __DIR__ . "/config.php";
}
// CONEXÃO COM O BANCO DE DADOS //
class DB
{
    private $connection = NULL;
    private static $_instance = NULL;
    public static function getInstance()
    {
        if (!self::$_instance) {
            self::$_instance = new self();
        }
        return self::$_instance;
    }
    private function __clone()
    {
    }
    public function getConnection($db_host, $db_port, $db_name, $db_user, $db_pass)
    {
        $con_name = $db_host . "_" . $db_name;
        try {
            if (!isset($this->connection[$con_name])) {
                $this->connection[$con_name] = new PDO("mysql:host=" . $db_host . ";port=" . $db_port . ";dbname=" . $db_name . ";charset=utf8mb4", $db_user, $db_pass, array(PDO::ATTR_PERSISTENT => true, PDO::ATTR_TIMEOUT => 5));
                $this->connection[$con_name]->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
            }
        } catch (PDOException $e) {
            if (debugEnabled()) {
                exit("<h2>Falha ao se conectar com o Banco de Dados:</h2> <p>Erro: ".$e->getMessage()."</p>");
            }
            return NULL;
        } catch (Exception $d) {
            if (debugEnabled()) {
                exit("<h2>Falha ao se conectar com o Banco de Dados:</h2> <p>Erro: ".$e->getMessage()."</p>");
            }
            return NULL;
        }
        return $this->connection[$con_name];
    }
}

// FIM DA CONEXÃO COM O BANCO DE DADOS //

function getConnection()
{
    return DB::getInstance()->getConnection(DB_HOST, DB_PORT, DB_NAME, DB_USER, DB_PASS);
}

function debugEnabled()
{
    if (defined("OFFICE_DEBUG") && OFFICE_DEBUG) {
        return true;
    }
    return false;
}

// FUNÇÕES DO SISTEMA ABAIXO //

function UrlAtual(){
 $dominio= $_SERVER['HTTP_HOST'];
 $url = "http://" . $dominio. $_SERVER['REQUEST_URI'];
 return $url;
}

function url(){
  return sprintf(
    "%s://%s%s",
    isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] != 'off' ? 'https' : 'http',
    $_SERVER['SERVER_NAME'],
    $_SERVER['REQUEST_URI']
);
}

function uploadImagem($diretorio){

    $PDO = getConnection();
    if ($PDO !== NULL) {
        $sql = "INSERT INTO `imagens`(`ID`, `DIRETORIO`, `DATA`) VALUES (NULL, '$diretorio', NOW())";
        $stmt = $PDO->prepare($sql);
        if ($stmt->execute()) {
            $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
        }
    }
    return $result;
}

function uploadFile($arquivo, $pasta, $tipos, $nome = null){
    if(isset($arquivo)){
        $infos = explode(".", $arquivo["name"]);

        if(!$nome){
            for($i = 0; $i < count($infos) - 1; $i++){
                $nomeOriginal = $nomeOriginal . $infos[$i] . ".";
            }
        }
        else{
            $nomeOriginal = $nome . ".";
        }

        $tipoArquivo = $infos[count($infos) - 1];

        $tipoPermitido = false;
        foreach($tipos as $tipo){
            if(strtolower($tipoArquivo) == strtolower($tipo)){
                $tipoPermitido = true;
            }
        }
        if(!$tipoPermitido){
            $retorno["erro"] = "Tipo não permitido";
        }
        else{
            if(move_uploaded_file($arquivo['tmp_name'], $pasta . $nomeOriginal . $tipoArquivo)){
                $retorno["caminho"] = $pasta . $nomeOriginal . $tipoArquivo;
            }
            else{
                $retorno["erro"] = "Erro ao fazer upload";
            }
        }
    }
    else{
        $retorno["erro"] = "Arquivo nao setado";
    }
    return $retorno;
}

function fazerLogin($usuario, $senha){

    $PDO = getConnection();
    if ($PDO !== NULL) {
        $sql = "SELECT * FROM usuarios WHERE usuario = :usuario AND senha = :senha;";
        $stmt = $PDO->prepare($sql);
        $stmt->bindParam(":usuario", $usuario, PDO::PARAM_STR, 300);
        $stmt->bindParam(":senha", $senha, PDO::PARAM_STR, 300);
        if ($stmt->execute()) {
            $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
        }
    }
    return $result;
}

function buscarUsuario($usuario){

    $PDO = getConnection();
    if ($PDO !== NULL) {
        $sql = "SELECT * FROM usuarios WHERE usuario = :usuario;";
        $stmt = $PDO->prepare($sql);
        $stmt->bindParam(":usuario", $usuario, PDO::PARAM_STR, 300);
        if ($stmt->execute()) {
            $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
        }
    }
    return $result[0];
}

function buscarUsuarios(){

    $PDO = getConnection();
    if ($PDO !== NULL) {
        $sql = "SELECT * FROM usuarios";
        $stmt = $PDO->prepare($sql);
        if ($stmt->execute()) {
            $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
        }
    }
    return $result;
}

function adicionarUsuario($nome, $usuario, $senha, $nivel){

    $PDO = getConnection();
    if ($PDO !== NULL) {
        $sql = "INSERT INTO `usuarios` (`id`, `nome`, `usuario`, `senha`, `nivel`) VALUES (NULL, :nome, :usuario, :senha, :nivel);";
        $stmt = $PDO->prepare($sql);
        $stmt->bindParam(":nome", $nome, PDO::PARAM_STR, 300);
        $stmt->bindParam(":usuario", $usuario, PDO::PARAM_STR, 300);
        $stmt->bindParam(":senha", $senha, PDO::PARAM_STR, 300);
        $stmt->bindParam(":nivel", $nivel, PDO::PARAM_STR, 300);
        if ($stmt->execute()) {
            return true;
        }
    }
    return false;
}

function buscarUsuarioID($id){

    $PDO = getConnection();
    if ($PDO !== NULL) {
        $sql = "SELECT * FROM usuarios WHERE id = :id;";
        $stmt = $PDO->prepare($sql);
        $stmt->bindParam(":id", $id, PDO::PARAM_INT);
        if ($stmt->execute()) {
            $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
        }   
    }
    return $result[0];
}

function excluirUsuario($id){

    $PDO = getConnection();
    if ($PDO !== NULL) {
        $sql = "DELETE * FROM `usuarios` WHERE id = :id;";
        $stmt = $PDO->prepare($sql);
        $stmt->bindParam(":id", $id, PDO::PARAM_STR, 300);
        if ($stmt->execute()) {
            return true;
        }
    }
    return false;
}

function atualizarUsuario($id, $nome, $usuario, $senha, $nivel){

    $PDO = getConnection();
    if ($PDO !== NULL) {

        $sql = "UPDATE `usuarios` SET `nome` = :nome, `usuario` = :usuario, `senha` = :senha, `nivel` = :nivel WHERE `usuarios`.`id` = :id;";

        $stmt = $PDO->prepare($sql);
        $stmt->bindParam(":id", $id, PDO::PARAM_INT);
        $stmt->bindParam(":nome", $nome, PDO::PARAM_STR, 300);
        $stmt->bindParam(":usuario", $usuario, PDO::PARAM_STR, 300);
        $stmt->bindParam(":senha", $senha, PDO::PARAM_STR, 300);
        $stmt->bindParam(":nivel", $nivel, PDO::PARAM_STR, 300);
        if ($stmt->execute()) {
            return true;
        }
    }
    return false;
}

function atualizarUsuario2($id, $usuario, $senha){

    $PDO = getConnection();
    if ($PDO !== NULL) {

        $sql = "UPDATE `usuarios` SET `usuario` = :usuario, `senha` = :senha WHERE `usuarios`.`id` = :id;";

        $stmt = $PDO->prepare($sql);
        $stmt->bindParam(":id", $id, PDO::PARAM_INT);
        $stmt->bindParam(":usuario", $usuario, PDO::PARAM_STR, 300);
        $stmt->bindParam(":senha", $senha, PDO::PARAM_STR, 300);

        if ($stmt->execute()) {
            return true;
        }
    }
    return false;
}

function buscarApp(){

    $PDO = getConnection();
    if ($PDO !== NULL) {
        $sql = "SELECT * FROM app WHERE id = 1;";
        $stmt = $PDO->prepare($sql);
        if ($stmt->execute()) {
            $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
        }
    }
    return $result[0];
}

function atualizarApp($api_dominio, $api_register, $api_auth, $api_email, $api_psp, $login_logo, $sidebar_logo, $bg, $vod_bg, $trans1, $cor1, $trans2, $cor2, $trans3, $cor3, $info_suporte, $campo1, $campo2, $campo3){ 

    $PDO = getConnection();
    if ($PDO !== NULL) {

        $sql = "UPDATE `app` SET `api_dominio` = :api_dominio, `api_register` = :api_register, `api_auth` = :api_auth, `api_email` = :api_email, `api_psp` = :api_psp, `login_logo` = :login_logo, `sidebar_logo` = :sidebar_logo, `bg` = :bg, `vod_bg` = :vod_bg, `trans1` = :trans1, `cor1` = :cor1, `trans2` = :trans2, `cor2` = :cor2, `trans3` = :trans3, `cor3` = :cor3, `info_suporte` = :info_suporte, `campo1` = :campo1, `campo2` = :campo2, `campo3` = :campo3 WHERE `app`.`id` = 1";

        $stmt = $PDO->prepare($sql);
        $stmt->bindParam(":api_dominio", $api_dominio, PDO::PARAM_STR, 300);
        $stmt->bindParam(":api_register", $api_register, PDO::PARAM_STR, 300);
        $stmt->bindParam(":api_auth", $api_auth, PDO::PARAM_STR, 300);
        $stmt->bindParam(":api_email", $api_email, PDO::PARAM_STR, 300);
        $stmt->bindParam(":api_psp", $api_psp, PDO::PARAM_STR, 300);
        $stmt->bindParam(":login_logo", $login_logo, PDO::PARAM_STR, 300);
        $stmt->bindParam(":sidebar_logo", $sidebar_logo, PDO::PARAM_STR, 300);
        $stmt->bindParam(":bg", $bg, PDO::PARAM_STR, 300);
        $stmt->bindParam(":vod_bg", $vod_bg, PDO::PARAM_STR, 300);
        $stmt->bindParam(":trans1", $trans1, PDO::PARAM_STR, 300);
        $stmt->bindParam(":cor1", $cor1, PDO::PARAM_STR, 300);
        $stmt->bindParam(":trans2", $trans2, PDO::PARAM_STR, 300);
        $stmt->bindParam(":cor2", $cor2, PDO::PARAM_STR, 300);
        $stmt->bindParam(":trans3", $trans3, PDO::PARAM_STR, 300);
        $stmt->bindParam(":cor3", $cor3, PDO::PARAM_STR, 300);
        $stmt->bindParam(":info_suporte", $info_suporte, PDO::PARAM_STR, 300);
        $stmt->bindParam(":campo1", $campo1, PDO::PARAM_STR, 300);
        $stmt->bindParam(":campo2", $campo2, PDO::PARAM_STR, 300);
        $stmt->bindParam(":campo3", $campo3, PDO::PARAM_STR, 300);
        if ($stmt->execute()) {
            return true;
        }
    }
    return false;
}

function buscarBanners(){

    $PDO = getConnection();
    if ($PDO !== NULL) {
        $sql = "SELECT * FROM banners ORDER BY id ASC;";
        $stmt = $PDO->prepare($sql);
        if ($stmt->execute()) {
            $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
        }
    }
    return $result;
}

function buscarBannersID($id){

    $PDO = getConnection();
    if ($PDO !== NULL) {
        $sql = "SELECT * FROM banners WHERE id = :id AND status = 1;";
        $stmt = $PDO->prepare($sql);
        $stmt->bindParam(":id", $id, PDO::PARAM_INT);
        if ($stmt->execute()) {
            $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
        }   
    }
    return $result[0];
}

function adicionarBanner($nome, $imagem, $link){

    $PDO = getConnection();
    if ($PDO !== NULL) {
        $sql = "INSERT INTO `banners` (`id`, `nome`, `imagem`, `link`) VALUES (NULL, :nome, :imagem, :link);";
        $stmt = $PDO->prepare($sql);
        $stmt->bindParam(":nome", $nome, PDO::PARAM_STR, 300);
        $stmt->bindParam(":imagem", $imagem, PDO::PARAM_STR, 300);
        $stmt->bindParam(":link", $link, PDO::PARAM_STR, 300);
        if ($stmt->execute()) {
            return true;
        }
    }
    return false;
}

function atualizarBanner($id, $nome, $imagem, $link){

    $PDO = getConnection();
    if ($PDO !== NULL) {

        $sql = "UPDATE `banners` SET `nome` = :nome, `imagem` = :imagem, `link` = :link WHERE `banners`.`id` = :id;";

        $stmt = $PDO->prepare($sql);
        $stmt->bindParam(":id", $id, PDO::PARAM_INT);
        $stmt->bindParam(":nome", $nome, PDO::PARAM_STR, 300);
        $stmt->bindParam(":imagem", $imagem, PDO::PARAM_STR, 300);
        $stmt->bindParam(":link", $link, PDO::PARAM_INT);
        if ($stmt->execute()) {
            return true;
        }
    }
    return false;
}

function ativarDesativarBanner($id){

    $PDO = getConnection();
    if ($PDO !== NULL) {
        $sql = "UPDATE `banners` SET `status` = !`status` WHERE `banners`.`id` = :id LIMIT 1;";
        $stmt = $PDO->prepare($sql);
        $stmt->bindParam(":id", $id, PDO::PARAM_INT);
        if ($stmt->execute()) {
            return true;
        }
    }
    return false;
}

function codificarApi($str){
$substituicao = array(
        '%' => 'cp',
        '+' => 'im',
        'a' => 'ze',
        'b' => 'IG',
        'c' => 'gp',
        'd' => 'tS',
        'e' => 'tK',
        'f' => 'eD',
        'g' => 'wG',
        'h' => 'Hd',
        'i' => 'Ta',
        'j' => 'Mz',
        'k' => 'NV',
        'l' => 'zy',
        'm' => 'Xg',
        'n' => 'ZP',
        'o' => 'Jw',
        'p' => 'Ab',
        'q' => 'vS',
        'r' => 'mo',
        's' => 'jR',
        't' => 'Em',
        'u' => 'Dr',
        'v' => 'lr',
        'w' => 'cW',
        'x' => 'JW',
        'y' => 'yw',
        'z' => 'yL',
        '"' => 'Ns',
        '\'' => 'gh',
        '{' => 'ia',
        '}' => 'rW',
        '[' => 'fw',
        ']' => 'Wi',
        ':' => 'Nu',
        ',' => 'nX',
        '=' => 'ml',
        '0' => 'kf',
        '1' => 'AB',
        '2' => 'tz',
        '3' => 'tC',
        '4' => 'fc',
        '5' => 'Et',
        '6' => 'BH',
        '7' => 'pC',
        '8' => 'Yx',
        '9' => 'vv',
        ' ' => 'Zt',
        '!' => 'Rl',
        '?' => 'Pk',
        '.' => 'pV',
        '/' => 'Er',
        '\\' =>'gg',
        ';' => 'fV',
        '&' => 'xZ',
        '@' => 'ms',
        '-' => 'jj',
        '_' => 'Ik',
        '#' => 'rj',
        'A' => 'jS',
        'B' => 'rR',
        'C' => 'MK',
        'D' => 'Kd',
        'E' => 'SU',
        'F' => 'gN',
        'G' => 'BX',
        'H' => 'LR',
        'I' => 'Vd',
        'J' => 'BA',
        'K' => 'QL',
        'L' => 'Ma',
        'M' => 'Nw',
        'N' => 'RV',
        'O' => 'VM',
        'P' => 'ba',
        'Q' => 'BD',
        'R' => 'rO',
        'S' => 'Rw',
        'T' => 'qI',
        'U' => 'Ty',
        'V' => 'fu',
        'W' => 'VS',
        'X' => 'fd',
        'Y' => 'Uf',
        'Z' => 'mn',
    );
  $api = strtr($str, $substituicao);
  return $api;
}
function codificarDom($dominio){
$substituicao = array(
   'a' => 'ze',
   'b' => 'IG',
   'c' => 'gp',
   'd' => 'tS',
   'e' => 'tK',
   'f' => 'eD',
   'g' => 'wG',
   'h' => 'Hd',
   'i' => 'Ta',
   'j' => 'Mz',
   'k' => 'NV',
   'l' => 'zy',
   'm' => 'Xg',
   'n' => 'ZP',
   'o' => 'Jw',
   'p' => 'Ab',
   'q' => 'vS',
   'r' => 'mo',
   's' => 'jR',
   't' => 'Em',
   'u' => 'Dr',
   'v' => 'lr',
   'w' => 'cW',
   'x' => 'JW',
   'y' => 'yw',
   'z' => 'yL',
   ':' => 'Ns',
   '/' => 'gh',
   '.' => 'ia'
    );
  $dom = strtr($dominio, $substituicao);
  return $dom;
}
function transparencia($trans){
    $substituicao = array(
      'FF' => '100%',
      'E6' => '90%',
      'CC' => '80%',
      'B3' => '70%',
      '99' => '60%',
      '80' => '50%',
      '66' => '40%',
      '4D' => '30%',
      '33' => '20%',
      '1A' => '10%',
      '00' => '0%'
  );
    $transparencia = strtr($trans, $substituicao);
    return $transparencia;
}
?>